//  Listing 11.1. Przykad przekazania obiektw 
//  jako parametrw funkcji poprzez warto

#include <iostream.h>

class Rational 
{
  long nmr, dnm;           		// prywatne dane
  void normalize();                	// prywatne metody
public:
        // konstruktor oglny, konwertujcy i domylny
  Rational(long n=0, long d=1) 
   { nmr = n; dnm = d;
     this->normalize();
     cout << " obiekt utworzony (konstruktor): " << nmr << " " << dnm << endl; 
   }
  Rational(const Rational &r) 		// konstruktor kopiujcy
   { 
     nmr = r.nmr; dnm = r.dnm;
     cout << " obiekt skopiowany (konstruktor kopii): " << nmr << " " << dnm << endl; 
   }
  void operator = (const Rational &r) 	// operator przypisania
   { 
     nmr = r.nmr; dnm = r.dnm;
     cout << " obiekt przypisany (operator=()): " << nmr << " " << dnm << endl; 
   }
  ~Rational() 				// destruktor
   { 
     cout << " obiekt usunity (destruktor): " << nmr << " " << dnm << endl; 
   }
  friend Rational operator + (const Rational x, const Rational y);
  void show() const;
} ; 					// koniec specyfikacji klasy

void Rational::show() const
  { cout << " " << nmr << "/" << dnm; }
void Rational::normalize() 		// prywatna metoda
  { if (nmr == 0) { dnm = 1; return; }
int sign = 1;
if (nmr < 0) { sign = -1; nmr = -nmr; } 	// zmie znak
if (dnm < 0) { sign = -sign; dnm = -dnm; } 	// by obydwa byy dodatnie
long gcd = nmr, value = dnm; 			// najwikszy wsplny podzielnik
while (value != gcd) { 				// zatrzymaj po znalezieniu n.w.p.
if (gcd > value)
gcd = gcd - value; 				// odejmuj liczb mniejsz od wikszej
else value = value - gcd; }
nmr = sign * (nmr/gcd); dnm = dnm/gcd; } 	// mianownik dodatni

Rational operator + (const Rational x, const Rational y)
  { return Rational(y.nmr*x.dnm + x.nmr*y.dnm, y.dnm*x.dnm); }

int main()
{ 
  Rational a(1,4), b(3,2), c;
  cout << endl;
  c = a + b;
  a.show(); cout << " +"; b.show(); cout << " ="; c.show();
  cout << endl << endl;
  return 0;
}
